
# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")
library("reshape2")

# source and generate data
source("generate.R")

# list objects in the working environment
ls() 

# http://analytixagilitylab.com/technical-tutorials/the-fundamentals-of-ggplot-explained
# http://ronkeizer.github.io/vpc/

# next task is to learn what data is actually being generated!

# pie chart involving three measures?

# list the variables in base
names(base)

# list the structure of base
str(base)

# print first 10 rows of base
head(base, n=10)

# print last 5 rows of base
tail(base, n=5)

# reshape2 using melt and cast examples

x1 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y1 <- c(8.04,6.95,7.58,8.81,8.33,9.96,7.24,4.26,10.84,4.82,5.68)
x2 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y2 <- c(9.14,8.14,8.74,8.77,9.26,8.10,6.13,3.10,9.13,7.26,4.74)
x3 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y3 <- c(7.46,6.77,12.74,7.11,7.81,8.84,6.08,5.39,8.15,6.42,5.73)
x4 <- c(8.0,8.0,8.0,8.0,8.0,8.0,8.0,19.0,8.0,8.0,8.0)
y4 <- c(6.58,5.76,7.71,8.84,8.47,7.04,5.25,12.50,5.56,7.91,6.89)


anscombe <- data.frame(x1,y1,x2,y2,x3,y3,x4,y4)
anscombe_m <- melt(anscombe)


# now for some ggplot2 plotting magic
p0 <- ggplot(email, aes(x = Team, y = responseTime, color = Team)) # just initializes
p0 <- p0 + geom_point() + 
           geom_smooth() + 
           facet_wrap(~ Team) + 
           geom_line(aes(group = Team))

# now for some ggplot2 magic
#p1 <- ggplot(grouping, aes(x = uid, y = group.3, color = group.3)) # just initializes
#p1 <- p1 + geom_point() 

# boxplot with flipped axes
p2 <- ggplot(email, aes(x = Team, y = responseTime, fill = as.factor(Team))) 
p2 <- p2 + geom_boxplot() + 
           geom_jitter() + #coord_cartesian(xlim = c(-100, 10)) + 
           coord_flip() 

# histogram overlaid with kernel density curve
p3 <- ggplot(email, aes(x=responseTime)) 
p3 <- p3 +  geom_histogram(aes(y=..density..), binwidth=.5, colour="black", fill="white") + 
            geom_density(alpha=.2, fill="#FF6666") + 
            xlab("response time") + 
            ggtitle("Response time")

# save graph to file
ggsave(file="graph.pdf")

# qqplot to check for normal distribution
# normalise data
email$responseTime <- (email$responseTime - mean(email$responseTime)) / sd(email$responseTime)
#v <- qplot(sample = responseTime, data = email, colour = factor(Team))
p4 <- qplot(sample = responseTime, data = email)


# pie chart in ggplot2
#http://www.r-chart.com/2010/07/pie-charts-in-ggplot2.html

#  
# RUN REGRESSION AND APPEND PREDICTION INTERVALS
lm_fit  = lm(responseTime ~ Time + Team, data = email)
response_given_time_Team = data.frame(email, predict(lm_fit, interval = 'prediction'))

# PLOT WITH REGRESSION LINE, CONFIDENCE INTERVAL AND PREDICTION INTERVAL
p5 <- ggplot(response_given_time_Team, aes(x = Time, y = responseTime, colour = factor(Team))) + 
      geom_point() +
      #geom_smooth(method = 'lm', aes(fill = 'confidence'), alpha = 0.5) +
      geom_smooth(method = 'lm', aes(fill = 'confidence')) +
      geom_ribbon(aes(y = fit, ymin = lwr, ymax = upr, fill = 'prediction'),
              alpha = 0.2) +
      scale_fill_manual('Interval', values = c('green', 'blue')) #+
      #opts(legend.position = c(0.20, 0.85))



# pie chart is just bar chart in a polar coordinate system
p8 <- ggplot(base,  aes(x = "Team", fill = as.factor(Team)) ) +
       geom_bar()

p9 <- ggplot(base, aes(x = "Team", fill = as.factor(Team)) ) +
       geom_bar() +
       coord_polar(theta = "y") +
       scale_x_discrete("")


#p10 <- ggplot(grouping, aes(x = group.1, y = group.2, color = group.3)) # just initializes
#p10 <- p10 + geom_point() + 
#  geom_smooth() + 
#  facet_wrap(~ group.3) + 
#  geom_line(aes(group = group.3))
